/**
 * AgenticWP Admin Settings Bootstrap
 *
 * Initializes all admin feature modules for the settings screen.
 * Coordinates module loading in proper order.
 *
 * @file
 * @since 1.0.0
 * @package AgenticWP
 */

(function($) {
	'use strict';

	/**
	 * Initialize all admin modules on document ready.
	 */
	$(function() {
		const AgenticWPAdmin = window.AgenticWPAdmin || {};
		const modules = [
			AgenticWPAdmin.buttonEnhancements,
			AgenticWPAdmin.apiKeys,
			AgenticWPAdmin.defaultImage,
			AgenticWPAdmin.characterCounter,
			AgenticWPAdmin.samplePrompts,
			AgenticWPAdmin.jobMonitor,
			AgenticWPAdmin.settingsDependencies,
			AgenticWPAdmin.actionsManager,
			AgenticWPAdmin.collapsibleSections,
			AgenticWPAdmin.modelSelection,
			AgenticWPAdmin.DropdownAutoSave,
			AgenticWPAdmin.tooltips
		];

		modules.forEach(function(module) {
			if (module && typeof module.init === 'function') {
				module.init();
			}
		});
	});
})(jQuery);
