<?php
/**
 * Schema settings class for AgenticWP plugin.
 *
 * @package AgenticWP
 */

namespace Agentic_WP;

defined( 'ABSPATH' ) || exit;

/**
 * Handles schema/organization settings.
 */
class Settings_Schema extends Settings_Base {

	/**
	 * Registers schema settings fields.
	 *
	 * @since 1.0.0
	 */
	public function register_settings(): void {
		register_setting(
			'agentic_wp',
			'agentic_wp_organization_name',
			array(
				'type'              => 'string',
				'sanitize_callback' => 'sanitize_text_field',
				'default'           => '',
			)
		);

		register_setting(
			'agentic_wp',
			'agentic_wp_organization_logo',
			array(
				'type'              => 'string',
				'sanitize_callback' => 'esc_url_raw',
				'default'           => '',
			)
		);

		register_setting(
			'agentic_wp',
			'agentic_wp_organization_email',
			array(
				'type'              => 'string',
				'sanitize_callback' => 'sanitize_email',
				'default'           => '',
			)
		);

		register_setting(
			'agentic_wp',
			'agentic_wp_organization_phone',
			array(
				'type'              => 'string',
				'sanitize_callback' => 'sanitize_text_field',
				'default'           => '',
			)
		);
	}

	/**
	 * Renders organization name field.
	 *
	 * @since 1.0.0
	 */
	public function organization_name_field() {
		$value = get_option( 'agentic_wp_organization_name', get_bloginfo( 'name' ) );
		echo '<input type="text" name="agentic_wp_organization_name" value="' . esc_attr( $value ) . '" class="regular-text" />';
		echo '<p class="description">' . esc_html__( 'Organization name for schema markup. Defaults to site name if empty.', 'agenticwp' ) . '</p>';
	}

	/**
	 * Renders organization logo field.
	 *
	 * @since 1.0.0
	 */
	public function organization_logo_field() {
		$value = get_option( 'agentic_wp_organization_logo', '' );
		echo '<input type="url" name="agentic_wp_organization_logo" value="' . esc_attr( $value ) . '" class="regular-text" />';
		echo '<p class="description">' . esc_html__( 'Full URL to your organization logo for schema markup.', 'agenticwp' ) . '</p>';
	}

	/**
	 * Renders organization email field.
	 *
	 * @since 1.0.0
	 */
	public function organization_email_field() {
		$value = get_option( 'agentic_wp_organization_email', get_option( 'admin_email' ) );
		echo '<input type="email" name="agentic_wp_organization_email" value="' . esc_attr( $value ) . '" class="regular-text" />';
		echo '<p class="description">' . esc_html__( 'Contact email for schema markup. Defaults to admin email if empty.', 'agenticwp' ) . '</p>';
	}

	/**
	 * Renders organization phone field.
	 *
	 * @since 1.0.0
	 */
	public function organization_phone_field() {
		$value = get_option( 'agentic_wp_organization_phone', '' );
		echo '<input type="tel" name="agentic_wp_organization_phone" value="' . esc_attr( $value ) . '" class="regular-text" />';
		echo '<p class="description">' . esc_html__( 'Contact phone number for schema markup (optional).', 'agenticwp' ) . '</p>';
	}
}
