/**
 * Button Enhancements
 *
 * Adds visual feedback states to buttons (pressed, focused) throughout
 * the admin interface.
 *
 * @file
 * @since 1.0.0
 * @package AgenticWP
 * @namespace AgenticWPAdmin.buttonEnhancements
 */

(function($) {
	'use strict';

	const AgenticWPAdmin = window.AgenticWPAdmin = window.AgenticWPAdmin || {};

	/**
	 * Initializes button enhancements.
	 */
	function init() {
		const buttonSelectors = [
			'.agenticwp-settings-section .button',
			'.agenticwp-modal-footer .button',
			'.agenticwp-jobs-controls .button',
			'.agenticwp-writing-directions-toolbar .button'
		].join(', ');

		$(document).on('mousedown', buttonSelectors, function() {
			$(this).addClass('button-pressed');
		});

		$(document).on('mouseup mouseleave', buttonSelectors, function() {
			$(this).removeClass('button-pressed');
		});

		$(document).on('focus', buttonSelectors, function() {
			$(this).addClass('button-focused');
		});

		$(document).on('blur', buttonSelectors, function() {
			$(this).removeClass('button-focused');
		});
	}

	AgenticWPAdmin.buttonEnhancements = {
		init: init
	};

})(jQuery);